##################################################################
# R code: Exercise 2.11(b) second part
# File: Piecewise_linear_regression.r
#
# INPUT:  x1x and x1y from first part 
# OUTPUT: Parameter estimates of reparameterized linear regression
#         model with smooth transition at "r".
##################################################################
n1 <- length(x1x)
smooa <- data.frame(x1y[2:n1],x1y[1:(n1-1)],x1x[2:n1],
         x1x[1:(n1-1)])
names(smooa) <- c("Yt", "Y1t", "Xt", "X1t")
thr2a.fit <- nls(Yt~phi*Y1t+BO*(1-phi)+B1*((Xt-Xo)-
   phi*(X1t-Xo))+ B2*(((Xt-Xo)^2+(delta^2)/4)^0.5-
   phi*((X1t-Xo)^2+(delta^2)/4)^0.5),smooa, 
   start = list(phi = 0.9,BO = 25,B1 = 2,B2 = 2,
   Xo = -1.8, delta = 1), trace=T) # Rough parameter estimates 
   list(summary(thr2a.fit)$parameters)
